package de.renew.netcomponents;

import java.util.Iterator;
import java.util.Vector;

import CH.ifa.draw.figures.GroupFigure;
import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.GuiPlugin;


/**
 * Command to group the selection into a NetComponentFigure.
 *
 * @see GroupFigure
 */
public class UngroupCommand extends UndoableCommand {
    // protected DrawingEditor fEditor;

    /**
     * Constructs an ungroup command.
     */
    public UngroupCommand() {
        super("ungroup" + " selection");
        // fEditor = editor;
    }

    /**
     * @see CH.ifa.draw.framework.UndoableCommand#executeUndoable()
     */
    @Override
    public boolean executeUndoable() {
        DrawingView view = GuiPlugin.getCurrent().getDrawingEditor().view();
        Vector<Figure> selected = view.selectionZOrdered();
        Drawing drawing = view.drawing();
        Iterator<Figure> it = selected.iterator();
        boolean netComponentFigureFound = false;
        while (it.hasNext()) {
            Figure figure = it.next();
            if (figure instanceof de.renew.netcomponents.NetComponentFigure) {
                drawing.remove(figure);
                netComponentFigureFound = true;
            }
            GuiPlugin.getCurrent().showStatus("Netcomponent detached.");
        }

        return netComponentFigureFound;
    }

    /**
     * @see CH.ifa.draw.util.Command#isExecutable()
     */
    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return GuiPlugin.getCurrent().getDrawingEditor().view().selectionCount() > 0;
    }
}