package de.renew.netcomponents;

import java.util.List;
import java.util.Vector;


/**
 * Class RemoveToolsControl
 * Controls the removing of the palettes which are selected by the user.
 *
 * @see RemoveToolsWindow
 * @author Lawrence Cabac
 *
 */
public class RemoveToolsControl {

    /**
     * The display for selecting ComponentsTools for removal.
     */
    private RemoveToolsWindow _rtw;

    /**
     * The List of the loaded ComponentsTools.
     */
    private Vector<ComponentsTool> _v;

    /**
     * The ComponentsToolPlugin
     */
    private ComponentsToolPlugin _ctp;

    /**
     * Method RemoveToolsControl.
     * @param ctp - the ComponentToolPlugin.
     */
    public RemoveToolsControl(ComponentsToolPlugin ctp) {
        this._ctp = ctp;
        this._v = ctp.getCTList();
        //        this.cpnapp = cpnapp;
        this._rtw = new RemoveToolsWindow(_v, this);
    }

    /**
     * Method removeFromList.
     * Removes the palette from the menuFrame (Renew GUI) and from the selection window.
     * @param os - the selected ComponentTools to be removed.
     */
    public void removeFromList(List os) {
        for (int i = 0; i < os.size(); i++) {
            ComponentsTool ct = (ComponentsTool) os.get(i);
            ct.remove();
            _v.remove(os.get(i));

            // check if remove selection is default palette 
            if (ct == _ctp.getDefaultCT()) {
                _ctp.setDefaultCT(null);
            }
        }

        //        cpnapp.menuFrame().pack();
        if (_v.isEmpty()) {
            _rtw.dispose();
        } else {
            _rtw.update(_v);
        }
    }

    /**
     * Method which updates the palette of GUI
     * @param v - Vector which has to been removed
     */
    public void update(Vector<ComponentsTool> v) {
        this._v = v;
        _rtw.update(v);
    }

    /**
     * Gets the Vector v, that consists of loaded instances of {@link ComponentsTool}.
     * @return the Vector v, that consists of loaded instances of {@link ComponentsTool}.
     */
    public Vector<ComponentsTool> getV() {
        return _v;
    }
}