package de.renew.netcomponents;

import CH.ifa.draw.util.Command;
import de.renew.plugin.IPlugin;


/**
 * The command that is executed for removing the netcomponents.
 * The user gets the option to select from a list of current palettes.
 *
 * @author Lawrence Cabac
 */
public class RemoveNetComponentsToolCommand extends Command {
    IPlugin _plugin;

    /**
     * The method is passed an IPlugin and assigns it to the class object _plugin
     * @param plugin - interface which must be implemented by all active plugins
     */
    public RemoveNetComponentsToolCommand(IPlugin plugin) {
        super("remove palette(s)");
        _plugin = plugin;
    }

    /**
     * Initiates the dialog for selecting Net-Component-Tools Palette for removal.
     * @see Command#execute()
     */
    @Override
    public void execute() {
        ComponentsToolPlugin ctp = (ComponentsToolPlugin) _plugin;
        ctp.removePalette();
    }
}