package de.renew.netcomponents;

import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;

import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.UndoableTool;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;


/**
 * A tool for inserting a vector of figures into a drawing .
 * All figures will be inserted individually
 * into the current drawing.
 * After insertion the inserted figures will automatically be selected
 * for convenient location adjustment.
 *
 * @author Lawrence Cabac
 * @version 0.2,  June 2002
 */
public class InsertionTool extends UndoableTool {
    /**
     * Log4J is a library which helps the developer to find errors.
     * logger is the log in which the errors for InsertionTool are stored
     */
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(InsertionTool.class);

    /**
     * the vector of figures to be drawn
     */
    private Vector<Figure> _fv;

    /**
     * the vector of figures that was drawn
     */
    private Vector<Figure> _selectedf;

    /**
     * Constructs a Tool for inserting a vector of figures
     *
     * @param fv - A growable Array of Objects which will be set as the local private _fv
     * @param editor - A DrawingEditor 
     */
    public InsertionTool(DrawingEditor editor, Vector<Figure> fv) {
        super(editor);
        _fv = fv;
    }

    /**
     * Inserts the vector of figures into the drawing at the given position.
     * @param e - the mouse event
     * @param x - the horizontal position of the mouse event
     * @param y - the vertical position of the mouse event
     */
    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        insert(x, y);
    }

    /**
     * Inserts the vector of figures into the drawing at the given position.
     * @param x - the horizontal position of the figures to be drawn
     * @param y - the vertical position of the figures to be drawn
     */
    public void insert(int x, int y) {
        try {
            Vector<Figure> v = _fv;

            FigureSelection fs = new FigureSelection(v);
            Vector<Figure> figures = fs.getData();
            _selectedf = figures;
            view().addAll(figures);

            view().addToSelectionAll(figures);
            StandardDrawingView.moveFigures(figures, x, y);

            Iterator<Figure> it = figures.iterator();
            while (it.hasNext()) {
                Figure figure = it.next();
                if (figure instanceof NetComponentFigure) {
                    NetComponentFigure ncfigure = (NetComponentFigure) figure;
                    ncfigure.updateListeners();
                }
            }


            // view().clearSelection();
            view().checkDamage();
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
        }

        changesMade();
    }

    /**
     * Do nothing while mouse is dragged.
     */
    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        //view().moveSelection(x,y);
    }

    /**
      * Reset tool choice to default on release of mouse button.
     */
    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        editor().toolDone();
        view().addToSelectionAll(_selectedf);
    }
}