package de.renew.navigator.vc;

import java.awt.Color;
import java.awt.Font;
import java.util.Set;
import javax.swing.tree.DefaultTreeCellRenderer;

import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.models.TreeElement;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-14
 */
class RepositoryTreeCellRenderer extends FileTreeCellRenderer {
    public static final Color MODIFIED_COLOR = new Color(0, 51, 153);
    public static final Color ADDED_COLOR = new Color(0, 102, 0);
    private static final int RGB_SHARE = 150;
    private final Set<Repository> _repositories;

    RepositoryTreeCellRenderer(Set<Repository> repositories) {
        this._repositories = repositories;
    }

    @Override
    public void render(
        DefaultTreeCellRenderer target, TreeElement element, boolean selected, boolean expanded)
    {
        for (Repository repository : _repositories) {
            if (repository.getRootDirectory().equals(element.getFile())) {
                target.setText(element.getFile().getName() + " @ " + repository.getBranch());
            }

            if (repository.getIgnored().contains(element.getFile())) {
                target.setForeground(new Color(RGB_SHARE, RGB_SHARE, RGB_SHARE));
                target.setText(target.getText());
                return;
            }

            final boolean isModified = repository.getModified().contains(element.getFile());
            final boolean isAdded = repository.getAdded().contains(element.getFile());

            if (isModified || isAdded) {
                target.setFont(
                    new Font(target.getFont().getName(), Font.BOLD, target.getFont().getSize()));
                target.setText(target.getText() + " - ");
            }

            if (isModified) {
                target.setText(target.getText() + "M");
                target.setForeground(MODIFIED_COLOR);
            }

            if (isAdded) {
                target.setText(target.getText() + "A");
                target.setForeground(ADDED_COLOR);
            }
        }
    }
}