package de.renew.navigator.vc.git;

import de.renew.navigator.vc.VersionControlAggregator;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.di.DIPlugin;


/**
 * Representative for the NavigatorGit plug-in.
 *
 * @author Konstantin Simon Maria Moellers
 */
final public class NavigatorGitPlugin extends DIPlugin {
    private final VersionControlAggregator _versionControlAggregator;
    private final GitVersionControl _versionControl;

    @Inject
    public NavigatorGitPlugin(VersionControlAggregator versionControlAggregator) {
        this._versionControlAggregator = versionControlAggregator;
        _versionControl = new GitVersionControl();
    }

    @Override
    public void init() {
        _versionControlAggregator.addVersionControl(_versionControl);
    }

    @Override
    public boolean cleanup() {
        return _versionControlAggregator.removeVersionControl(_versionControl);
    }
}