package de.renew.navigator.models;

import java.io.File;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertNotEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;


/**
 * @author Philipp Schult
 * @author Akram Ahmed Ammar
 * @version 2023-05-09
 */
public class TreeElementTest {

    @Mock
    private TreeElement _childElement;
    @Mock
    private TreeElement _parentElement;
    @Mock
    private TreeElement _newParentElement;
    private String _name;
    private String _newName;
    private File _file;

    @BeforeEach
    public void setUp() {
        _childElement = Mockito.mock(TreeElement.class, Mockito.CALLS_REAL_METHODS);
        _parentElement = Mockito.mock(TreeElement.class, Mockito.CALLS_REAL_METHODS);
        _newParentElement = Mockito.mock(TreeElement.class, Mockito.CALLS_REAL_METHODS);
        _name = "Child name";
        _newName = "Child new name";
        _file = new File("testfile");
    }

    @Test
    public void testSetParent() {
        _childElement.setParent(_parentElement);
        assertEquals(_parentElement, _childElement.getParent());
        assertNotEquals(_newParentElement, _childElement.getParent());
        _childElement.setParent(_newParentElement);
        assertEquals(_newParentElement, _childElement.getParent());
        assertNotEquals(_parentElement, _childElement.getParent());
    }

    @Test
    public void testSetName() {
        _childElement.setName(_name);
        assertEquals("Child name", _childElement.getName());
        assertNotEquals("Child new name", _childElement.getName());
        _childElement.setName(_newName);
        assertEquals("Child new name", _childElement.getName());
        assertNotEquals("Child name", _childElement.getName());
    }

    @Test
    public void testSetExcluded() {
        _childElement.setExcluded(true);
        assertTrue(_childElement.isExcluded());
        _childElement.setExcluded(false);
        assertFalse(_childElement.isExcluded());
    }

    @Test
    public void testSetFile() {
        _childElement.setFile(_file);
        assertEquals(_file, _childElement.getFile());
    }

    @Test
    public void testToString() {
        _childElement.setFile(_file);
        _childElement.setName(_name);
        String expectedResult =
            "TreeElement{" + "name='" + "Child name" + '\'' + ", file=" + "testfile" + '}';
        assertEquals(expectedResult, _childElement.toString());
    }
}
