package de.renew.navigator.gui.filters;

import java.awt.event.ActionEvent;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.SearchFilter;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.ArgumentMatchers.argThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

class JavaSearchFilterTest {

    private NavigatorFileTree fileTree;
    private JavaSearchFilter filter;

    @BeforeEach
    void setUp() {
        fileTree = mock(NavigatorFileTree.class);
        filter = new JavaSearchFilter(fileTree);
    }

    @Test
    void activatesFilterWhenNotPresent() {
        //given
        when(fileTree.getFileFilterByName("java")).thenReturn(null);

        //when
        filter.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, null));

        //then
        verify(fileTree).activateFileFilter(
            argThat(
                f -> "java".equals(f.getName()) && f.getType() == SearchFilter.Type.ENDS_WITH
                    && f.isCaseSensitive()));

        // and we notify observers, never deactivating
        verify(fileTree).notifyObservers();
        verify(fileTree, never()).deactivateFileFilter(anyString());
    }

    @Test
    void deactivatesFilterWhenPresent() {
        //given
        SearchFilter existing =
            new SearchFilter("java", SearchFilter.Type.ENDS_WITH, true, ".java", ".jsp");
        when(fileTree.getFileFilterByName("java")).thenReturn(existing);

        //when
        filter.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, null));

        //then
        verify(fileTree).deactivateFileFilter("java");
        verify(fileTree).notifyObservers();
        verify(fileTree, never()).activateFileFilter(any());
    }
}
