package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.navigator.FilesystemController;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;

class OpenHomeActionTest {

    private FilesystemController filesystem;
    private OpenHomeAction action;

    @BeforeEach
    void setUp() {
        // given
        filesystem = mock(FilesystemController.class);
        action = new OpenHomeAction(filesystem);
    }

    @Test
    void testIsActionPerformed() {
        // when
        action.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "openHome"));

        // then
        verify(filesystem, times(1)).loadFromProperties();
        verifyNoMoreInteractions(filesystem);
    }
}