package de.renew.navigator.models;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-08
 */
public enum DirectoryType {
    /**
     * Represents a directory type used for plugins.
     * This type denotes directories containing plugin-specific files or resources.
     */
    PLUGIN,
    /**
     * Represents a directory type used for source files.
     * This type denotes directories that contain source code.
     */
    SOURCE,
    /**
     * Represents a directory type used for test source files.
     * This type denotes directories that contain source code specifically related to testing purposes.
     */
    TEST_SOURCE,
    /**
     * Represents a directory type used for miscellaneous or undefined purposes.
     * This type is used when the directory does not fall under any specific predefined category.
     */
    ETC,
    /**
     * Represents a directory type used for packages.
     * This type denotes directories containing package-specific resources or classifications.
     */
    PACKAGE;
}