package de.renew.navigator.models;

import java.util.List;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-25
 */
public final class Directory extends TreeElement {

    /**
     * Flags whether this directory is opened.
     */
    private boolean _opened;

    /**
     * Holds the directory type of this tree element.
     */
    private DirectoryType _type;

    /**
     * This is a getter which gets the list of tree elements of the directory.
     * @return elements the list of tree elements of the directory.
     */
    public List<TreeElement> getChildren() {
        return _elements;
    }

    /**
     * This is a setter which sets the list of tree elements of the directory.
     * @param children The list of tree elements of the directory.
     */
    public void setChildren(List<TreeElement> children) {
        this._elements = children;
        setChanged();
    }

    /**
     * Checks whether the directory is opened.
     * @return true, when the directory is opened.
     */
    public boolean isOpened() {
        return _opened;
    }

    /**
     * This is a setter which sets whether the directory is opened.
     * @param opened The boolean that indicates whether the directory is opened.
     */
    public void setOpened(boolean opened) {
        this._opened = opened;
        if (opened) {
            if (getParent() instanceof Directory) {
                ((Directory) getParent()).setOpened(true);
            }
        } else {
            for (TreeElement child : _elements) {
                if (child instanceof Directory) {
                    ((Directory) child).setOpened(false);
                }
            }
        }

        setChanged();
    }

    /**
     * This is a getter which gets the type of the directory.
     * @return _type the DirectoryType of the directory.
     */
    public DirectoryType getType() {
        return _type;
    }

    /**
     * This is a setter which sets the type of the directory.
     * @param type The DirectoryType of the directory.
     */
    public void setType(DirectoryType type) {
        this._type = type;
    }

    @Override
    public void setExcluded(boolean excluded) {
        super.setExcluded(excluded);
        if (excluded) {
            for (TreeElement child : _elements) {
                child.setExcluded(true);
            }
            return;
        }

        if (getParent() instanceof TreeElement) {
            ((TreeElement) getParent()).setExcluded(false);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + _elements.size();
    }

    /**
     * Expands all directories recursively.
     */
    @Override
    public void expandAll() {
        setOpened(true);
        for (TreeElement child : _elements) {
            if (!(child instanceof Directory directory)) {
                continue;
            }

            directory.expandAll();
        }
    }
}