package de.renew.navigator.models;

import java.util.Observable;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-08
 */
@SuppressWarnings("deprecation")
public class BackgroundTask extends Observable {

    private String _name;
    private float _current;
    private Runnable _cancelAction;

    /**
     * Constructor to create an instance of the background task class.
     * @param name The name of the background task.
     */
    public BackgroundTask(String name) {
        this._name = name;
        this._current = -1;
    }

    /**
     * This is a getter which gets the name of the background task.
     * @return _name the String of the name of the background task.
     */
    public String getName() {
        return _name;
    }

    /**
     * This is a setter which sets the name of the background task.
     * @param name The String of the name of the background task.
     */
    public void setName(String name) {
        this._name = name;
        setChanged();
    }

    /**
     * This is a getter which gets the current value of the background task.
     * @return _current the float of the current value of the background task.
     */
    public float getCurrent() {
        return _current;
    }

    /**
     * This is a setter which sets the current value of the background task.
     * @param current The float of the current value of the background task.
     */
    public void setCurrent(float current) {
        this._current = current;
        setChanged();
    }

    /**
     * @return if this task is in indeterminate state.
     */
    public boolean isIndeterminate() {
        return _current == -1;
    }

    /**
     * @return if this task can be cancelled.
     */
    public boolean isCancelable() {
        return this._cancelAction != null;
    }

    /**
     * This is a getter which gets the action of the background task, that gets executed, when the task gets canceled.
     * @return _cancelAction the Runnable that represents the action of the background task.
     */
    public Runnable getCancelAction() {
        return _cancelAction;
    }

    /**
     * This is a setter which sets the action of the background task, that gets executed, when the task gets canceled.
     * @param cancelAction The Runnable that represents the action of the background task.
     */
    public void setCancelAction(Runnable cancelAction) {
        this._cancelAction = cancelAction;
        setChanged();
    }

    /**
     * Cancels the background task.
     */
    public void cancel() {
        if (this._cancelAction != null) {
            this._cancelAction.run();
        }
    }

    /**
     * Increases the current value of the background task.
     * @param amount The float by whose value the current value is to be increased.
     */
    public void increaseCurrent(float amount) {
        _current += amount;
        setChanged();
    }
}