package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorAction;
import de.renew.navigator.gui.NavigatorIcons;


/**
 * Refreshes all files contained in the navigator.
 *
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-26
 */
public class RefreshAllAction extends NavigatorAction {
    /**
     * The {@link FilesystemController} instance that this action interacts with.
     */
    private final FilesystemController _fileSystem;

    /**
     * Constructor for the RefreshAllAction.
     * @param filesystem the {@link FilesystemController} instance that this action interacts with.
     */
    public RefreshAllAction(FilesystemController filesystem) {
        super(
            "Refresh All (Ctrl+R)", NavigatorIcons.ICON_REFRESH_ALL,
            KeyStroke.getKeyStroke(KeyEvent.VK_R, InputEvent.CTRL_MASK));
        this._fileSystem = filesystem;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        _fileSystem.refreshPaths();
    }
}