package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;

import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorAction;
import de.renew.navigator.gui.NavigatorIcons;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-26
 */
public class OpenHomeAction extends NavigatorAction {
    /**
     * Represents an instance of the {@link FilesystemController} used for managing
     * filesystem operations, such as loading directories, handling properties, and
     * managing files within the application.
     *
     * This variable is immutable and is initialized through the constructor
     * of the containing class. It serves as the central controller responsible for
     * handling all filesystem-related tasks, ensuring proper integration of the
     * filesystem with the application's functionality.
     */
    private final FilesystemController _filesystem;

    /**
     * Initializes an action to open home paths of the Navigator's properties.
     *
     * @param filesystem the {@link FilesystemController} instance used for managing filesystem operations
     */
    public OpenHomeAction(final FilesystemController filesystem) {
        super("Open Home paths of Navigator properties", NavigatorIcons.ICON_HOME, null);
        this._filesystem = filesystem;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        _filesystem.loadFromProperties();
    }
}