package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.gui.NavigatorIcons;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-26
 */
public class CollapseAllAction extends NavigatorAction {
    /**
     * The {@link NavigatorGui} instance that this action interacts with.
     */
    private final NavigatorGui _gui;

    /**
     * Constructor for creating an instance of CollapseAllAction.
     *
     * @param gui the {@link NavigatorGui} instance that this action interacts with.
     */
    @SuppressWarnings("deprecation")
    public CollapseAllAction(final NavigatorGui gui) {
        super(
            "Collapse All (Ctrl+Shift+C)", NavigatorIcons.ICON_COLLAPSE_ALL,
            KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_MASK | InputEvent.SHIFT_MASK));
        this._gui = gui;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        _gui.collapseAll();
    }
}