package de.renew.navigator;

import java.io.PrintStream;

import CH.ifa.draw.util.Command;
import de.renew.plugin.command.CLCommand;


/**
 * This is the OpenNavigatorCommand class to open the Navigator.
 *
 * @author Hannes Ahrens (4ahrens)
 * @version March 2009
 * <p>
 * Add CLCommand interface.
 *
 * @author Lawrence Cabac (cabac)
 * @version September 2015
 */
public class OpenNavigatorCommand extends Command implements CLCommand {
    /**
     * Represents the command string used to identify the "Open Navigator" action.
     * The value of this constant is "navigator". It is utilized within the
     * context of command-line execution and user interface actions to trigger
     * the opening of the Navigator window.
     */
    public static final String CMD = "navigator";
    private final NavigatorPlugin _plugin;

    /**
     * @param plugin the NavigatorPlugin to call on execution
     */
    public OpenNavigatorCommand(NavigatorPlugin plugin) {
        super("Open Navigator");
        _plugin = plugin;
    }

    /**
     * Calls the NavigatorPlugin.openNavigator() method on execution.
     */
    @Override
    public void execute() {
        _plugin.openNavigator();
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.command.CLCommand#execute(java.lang.String[], java.io.PrintStream)
     */
    @Override
    public void execute(String[] args, PrintStream response) {
        execute();
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.command.CLCommand#getDescription()
     */
    @Override
    public String getDescription() {
        return "Opens the Navigator window.";
    }
}