package de.renew.navigator;

import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;


/**
 * An extension to the Navigator plugin.
 *
 * @author cabac
 */
public interface NavigatorExtension {

    /**
     * Configures the navigator with additional features.
     *
     * @param config The configuration to apply.
     */
    void configure(NavigatorConfigurator config);

    /**
     * Gets a menu item.
     *
     *@param tree the JTree containing the menu item.
     *@param x the int of the x-coordinate of the menu item.
     *@param y the int of the y-coordinate of the menu item.
     *@param lastPathComponent the object of the last path component of the  menu item.
     *@param mtn the mutable tree node associated with the menu item.
     *@return the JMenuItem with the given params.
     */
    JMenuItem getMenuItem(JTree tree, int x, int y, Object lastPathComponent, MutableTreeNode mtn);
}