package de.renew.navigator;

import java.util.Observable;
import java.util.Observer;

import de.renew.navigator.models.NavigatorFileTree;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-25
 */
abstract class NavigatorController implements Observer {
    /**
     * The Plugin containing the controller.
     */
    protected final NavigatorPlugin _plugin;
    /**
     * The model for the file tree structure managed by the navigation controller.
     */
    protected final NavigatorFileTree _model;

    /**
     * @param plugin the plugin containing the controller
     */
    public NavigatorController(final NavigatorPlugin plugin) {
        this._plugin = plugin;
        this._model = plugin.getModel();
    }

    /**
     * Gets executed each time the model changes.
     *
     * @param target Event target.
     */
    protected void onModelChanged(Object target) {}

    @Override
    public void update(Observable observable, Object o) {
        // Do not execute events if executor was the object itself
        if (o != null && o.equals(this)) {
            return;
        }

        if (observable == _model) {
            onModelChanged(o);
            return;
        }

        throw new RuntimeException(
            String.format("An unsuspected observable: %s", observable.getClass()));
    }
}