# Navigator

## User Guide

This plugin displays a window with a list of files which can be opened by Renew.

### Features

- Loads current File situation from the disc
- Persists the current navigator state to preferences

### Example Usage

1. Open the navigator plugin (File > Open Navigator or use the keyboard shortcut _Ctrl+Shift+N_)
2. Navigate to a net drawing file by double clicking on the directories until the net drawing is visible
3. Double click on the net drawing file to open it

### Provided Commands

- `navigator` - this command opens the navigator

### Installation

Install _Navigator_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

- `CH` : Adds a new panel
- `Log4j` : Logging framework
- `docking.frames.common` : Java Swing docking framework

### Configuration

During the initialization of Navigation, the following properties are read from the `renew.properties` file in the Renew root directory.

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**
:-----|:-----:|:-----|:-----
`de.renew.navigator.filesAtStartup`|String|Specifies which files should be loaded at startup of the navigator. It also defines which files are loaded by clicking on the home button.|null
`de.renew.navigator.workspace`|String|Specifies the path to your workspace, requires a fully qualified path, i.e.: `/path/to/your/desired/dir`.|null

## Developer Guide

### Core Classes

- `de.renew.navigator.NavigatorPlugin` : Creates a new instance of the _Navigator_ plugin

### How to Extend

_Navigator_ exposes the Interfaces:
- `de.renew.navigator.gui.NavigatorIcons`
- `de.renew.navigator.io.FileFilterBuilder`
- `de.renew.navigator.io.IOLoader`
- `de.renew.navigator.io.ProgressListener`
- `de.renew.navigator.NavigatorConfigurator`
- `de.renew.navigator.NavigatorExtender` - an extender for the navigator plugin. Plugins and buttons can be registered at the Navigator plugin
- `de.renew.navigator.NavigatorExtension` - an extension to the Navigator plugin
- `de.renew.navigator.NavigatorGui`

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

- The `de.renew.navigator.filesAtStartup property` exists at several locations:
  - Inside the resources/plugin.cfg file of the Navigator plugin
  - Inside the .renew.properties file in the home directory of the user
  - Inside the testing/start.sh file of a Mulan plugin
  
<!-- Contribution Info -->

<!-- License -->