package de.renew.call;

import de.renew.net.Net;
import de.renew.net.NetInstanceImpl;
import de.renew.net.NetLookup;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.unify.Impossible;

/**
 * {@link de.renew.net.NetInstance}-subclass which carries a reference to an object called owner. Such objects can implement the {@link NetOwner} interface so
 * that others can retrieve their owned NetInstance.
 */
public class OwnedNetInstance extends NetInstanceImpl {

    /**
     * The owner object.
     */
    public final Object _owner;

    /**
     * Constructs an owned net instance bound to the provided {@code owner}.
     *
     * @param netName the name for the {@link Net}.
     * @param owner the owner object.
     * @throws Impossible if the {@link Net} was {@code null}.
     * @throws NetNotFoundException if the {@link Net} is not loaded and no loader was set or the loader could not find the {@link Net}.
     */
    public OwnedNetInstance(String netName, Object owner) throws Impossible, NetNotFoundException {
        super(new NetLookup().findForName(netName));
        this._owner = owner;
    }
}
