package de.renew.call;

import de.renew.engine.searcher.LateExecutable;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Tuple;

/**
 * NotifyExecutable is an implementation of the {@link LateExecutable} interface and serves as a completion notification mechanism for synchronization
 * requests. It encapsulates a {@link SynchronisationRequest} and parameters, ensuring that upon execution, the appropriate completion signals are delivered.
 */
class NotifyExecutable implements LateExecutable {

    SynchronisationRequest _synchronisation;
    Tuple _parameters;

    /**
     * Constructs a {@link NotifyExecutable} object, which acts as a completion notification mechanism for synchronization requests.
     * It encapsulates the synchronization request and its associated parameters.
     *
     * @param synchronisation the {@link SynchronisationRequest} to be notified upon completion.
     * @param parameters the {@link Tuple} containing result parameters for the synchronization.
     */
    NotifyExecutable(SynchronisationRequest synchronisation, Tuple parameters) {
        this._synchronisation = synchronisation;
        this._parameters = parameters;
    }

    @Override
    public int phase() {
        return COMPLETION_NOTIFY;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        _synchronisation._resultParameters = _parameters;
        _synchronisation._resultSemaphor.V();
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable throwable) {
        // This should not happen, strictly speaking.
        // We do not perform any actions in order to
        // enable the user to detect this unusual situation.
    }
}
