package de.renew.lola2.parser;

/**
 * Exception thrown when there is an error parsing a Lola2 net file.
 */
public class NetFileParseError extends Exception {

    /**
     * Serial version UID for serialization.
     */
    public NetFileParseError() {
        super();
    }

    /**
     * Constructor for NetFileParseError with a message and cause.
     *
     * @param msg the error message
     * @param cause the cause of the error
     */
    public NetFileParseError(String msg, Throwable cause) {
        super(msg, cause);
    }

    /**
     * Constructor for NetFileParseError with a cause.
     *
     * @param cause the cause of the error
     */
    public NetFileParseError(Throwable cause) {
        super(cause);
    }

    /**
     * Constructor for NetFileParseError with a message.
     *
     * @param msg the error message
     */
    public NetFileParseError(String msg) {
        super(msg);
    }
}