/**
 *
 */

package de.renew.lola2.commands;

import javax.swing.WindowConstants;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.gui.LolaGUI;


/**
 * Opens the GUI.
 *
 * @author hewelt, wagner
 *
 */
public class OpenLolaGUICommand extends Command {
    private static org.apache.log4j.Logger _logger =
        org.apache.log4j.Logger.getLogger(OpenLolaGUICommand.class);
    private LolaGUI _gui = null;
    private String _lolaPath;

    /**
     * @param name the command name
     * @param path path the lola path
     */
    public OpenLolaGUICommand(String name, String path) {
        super(name);
        _lolaPath = path;
    }

    /* (non-Javadoc)
     * @see CH.ifa.draw.util.Command#execute()
     */
    @Override
    public void execute() {
        DrawApplication app = DrawPlugin.getGui();

        if (app.drawing() instanceof CPNDrawing) {
            if (_gui != null) {
                _gui.setVisible(true);
                _gui.toFront();
                // GUI checks itself on init
                //gui.checkNow();
            } else {
                _gui = new LolaGUI("Lola2 for Renew ", _lolaPath);
                _gui.setSize(400, 270);
                _gui.setVisible(true);
                _gui.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

                //gui.checkNow();
            }
        } else {
            DrawPlugin.getCurrent()
                .showStatus("[Lola GUI] Could not start, current drawing not a CPNDrawing.");
            _logger.error("[Lola GUI] Could not open GUI, no open drawing or not CPNDrawing");
        }
    }
}
