/**
 *
 */

package de.renew.lola2.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.Command;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.gui.CPNDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.lola2.LolaFileCreator;
import de.renew.plugin.command.CLCommand;


/**
 * This command exports the current drawing to a Lola file.
 * It is used in the GUI and can also be executed from the command line.
 */
public class ExportToLolaCommand extends Command implements CLCommand {
    private static org.apache.log4j.Logger _logger =
        org.apache.log4j.Logger.getLogger(ExportToLolaCommand.class);

    /**
     * Creates a new command with the given name.
     *
     * @param name the name of the command
     */
    public ExportToLolaCommand(String name) {
        super(name);
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.command.CLCommand#execute(java.lang.String[], java.io.PrintStream)
     */
    @Override
    public void execute(String[] args, PrintStream response) {
        // TODO Auto-generated method stub
    }

    @Override
    public void execute() {
        DrawingEditor drawingEditor = GuiPlugin.getCurrent().getDrawingEditor();
        Drawing drawing = drawingEditor.drawing();
        JFrame editor = DrawPlugin.getGui().getFrame();

        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setDialogTitle("Select a file to save exported net.");
        chooser.setToolTipText("Good Luck.");
        int returnValue = chooser.showSaveDialog(editor);
        File selectedFile;
        if (returnValue == JFileChooser.APPROVE_OPTION) {
            selectedFile = chooser.getSelectedFile();
        } else {
            _logger.info("User abort.");
            return;
        }
        try {
            OutputStream stream = new FileOutputStream(selectedFile);
            LolaFileCreator creator = new LolaFileCreator();
            creator.writeLolaFile(stream, (CPNDrawing) drawing);
            stream.flush();
            stream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.command.CLCommand#getDescription()
     */
    @Override
    public String getDescription() {
        return "Export to lola format.";
    }

    /* (non-Javadoc)
     * @see CH.ifa.draw.util.Command#execute()
     */

}
