package de.renew.logging.gui.test.helper;

import org.mockito.MockedStatic;
import org.mockito.Mockito;

import de.renew.engine.events.SimulationEvent;
import de.renew.logging.gui.LoggerTableModel;
import de.renew.logging.gui.MainRepositoryManager;
import de.renew.logging.gui.StepTrace;
import de.renew.logging.gui.StepTraceRepository;
import de.renew.simulatorontology.simulation.StepIdentifier;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * This class provides the mocks of the Logging Plugin
 */
public class LoggingMocks {
    public static StepTrace getStepTrace() {
        // Return Values
        final StepIdentifier stepIdentifier = getStepIdentifier();
        final SimulationEvent simulationEvent = getSimulationEvent();
        final SimulationEvent[] simulationEvents = new SimulationEvent[1];
        simulationEvents[0] = simulationEvent;

        // Mock setup
        final StepTrace stepTraceMock = mock(StepTrace.class);
        when(stepTraceMock.getStepIdentifier()).thenReturn(stepIdentifier);
        when(stepTraceMock.getEvents()).thenReturn(simulationEvents);
        return stepTraceMock;
    }

    /**
     * uses default values for the mock of the StepIdentifier
     */
    public static StepIdentifier getStepIdentifier() {
        return getStepIdentifier(5L, new long[2]);
    }

    public static StepIdentifier getStepIdentifier(
        final Long simulationRunId, final long[] stepCountVector)
    {
        final StepIdentifier mock = mock(StepIdentifier.class);
        when(mock.getSimulationRunId()).thenReturn(simulationRunId);
        when(mock.getComponents()).thenReturn(stepCountVector);
        return mock;
    }

    public static SimulationEvent getSimulationEvent() {
        return mock(SimulationEvent.class);
    }

    public static LoggerTableModel getLoggerTableModel(final StepTrace... stepTraces) {
        // setup
        final MainRepositoryManager mainRepositoryMock = mock(MainRepositoryManager.class);
        final StepTraceRepository stepTraceRepositoryMock = mock(StepTraceRepository.class);
        when(stepTraceRepositoryMock.getAllStepTraces()).thenReturn(stepTraces);

        try (final MockedStatic<MainRepositoryManager> statics =
            Mockito.mockStatic(MainRepositoryManager.class)) {
            statics.when(MainRepositoryManager::getInstance).thenReturn(mainRepositoryMock);
            when(mainRepositoryMock.getCurrentRepository("myLoggerTableModel"))
                .thenReturn(stepTraceRepositoryMock);

            return new LoggerTableModel("myLoggerTableModel");
        }
    }

}
