package de.renew.logging.gui.test;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Test;

import de.renew.logging.gui.TreeNodeAppenderWrapper;
import de.renew.logging.gui.test.helper.TestAppender;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class TreeNodeAppenderWrapperTest {

    @Test
    public void testGetLogger() {
        final Logger testlogger = Logger.getLogger("testlogger");
        final TreeNodeAppenderWrapper wrapper =
            new TreeNodeAppenderWrapper(testlogger, new TestAppender());

        assertEquals(testlogger, wrapper.getLogger());
    }

    @Test
    public void testGetAppender() {
        final TestAppender appender = new TestAppender();
        final TreeNodeAppenderWrapper wrapper = new TreeNodeAppenderWrapper(
            Logger.getLogger(TreeNodeAppenderWrapperTest.class), appender);

        assertEquals(appender, wrapper.getAppender());
    }

    @Test
    public void testToString() {
        final TestAppender appender = new TestAppender();
        final TreeNodeAppenderWrapper wrapper = new TreeNodeAppenderWrapper(
            Logger.getLogger(TreeNodeAppenderWrapperTest.class), appender);

        assertEquals(appender.getClass().getName(), wrapper.toString());

    }

}
