package de.renew.logging.gui;

import org.apache.log4j.Appender;

import de.renew.engine.common.SimulatorEventLogger;


/**
 * Wraps an {@link Appender}.
 * @author Sven Offermann
 * @deprecated This doesn't appear to be used anywhere.
 */
@Deprecated
public class AppenderWrapper {
    private Appender _appender = null;
    private String _loggerName;

    /**
     * Sets the appender in the wrapper.
     * @param appender {@link Appender}
     */
    public AppenderWrapper(Appender appender) {
        this._appender = appender;
    }

    /**
     *
     * @return {@link Appender}
     */
    public Appender getAppender() {
        return this._appender;
    }

    /**
     * Checks if the name of the wrapped logger is equal to or starts with: {@link SimulatorEventLogger#SIM_LOG_PREFIX}.
     * If the name is equal to  {@link SimulatorEventLogger#SIM_LOG_PREFIX} it is identified as the root logger.
     * Otherwise only the substring after {@link SimulatorEventLogger#SIM_LOG_PREFIX} is returned
     * @return "Simulation Root Logger" or the name after  "{@link SimulatorEventLogger#SIM_LOG_PREFIX}."
     */
    public String getLoggerName() {
        String name = null;
        if (_loggerName.equals(SimulatorEventLogger.SIM_LOG_PREFIX)) {
            name = "Simulation Root Logger";
        } else if (_loggerName.startsWith(SimulatorEventLogger.SIM_LOG_PREFIX + ".")) {
            name = _loggerName.substring(_loggerName.indexOf(".") + 1);
        }

        return name;
    }

    /**
     * @return the complete name of the logger.
     */
    public String getRealLoggerName() {
        return this._loggerName;
    }

    @Override
    public String toString() {
        return this.getLoggerName();
    }
}