package de.renew.logging.gui;

import org.apache.log4j.Appender;


/**
 *  An Appender builder is used to create new initialized instances of
 *  the different types of appenders, which can be used for logging.
 *  @author Sven Offermann
 */
public interface AppenderBuilder {

    /**
     * Creates new instance of an appender.
     *
     * @return the new instance of the appender
     * @throws InstantiationException if the creation of a new Appender failed
     */
    Appender newInstance() throws InstantiationException;
}