package de.renew.plugin.command;

import java.time.Instant;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

import static de.renew.plugin.command.CommandHelper.doExecuteSuccessfully;
import static de.renew.plugin.command.CommandHelper.doExecuteUnsuccessfully;
import static org.junit.jupiter.api.Assertions.assertEquals;

public class SleepCommandTest {


    @Test
    public void testGetArguments() {
        assertEquals("3", new SleepCommand().getArguments());
    }

    @Test
    public void testGetDescription() {
        assertEquals(
            "This command waits for a given time until the next command is executed.",
            new SleepCommand().getDescription());
    }

    @Disabled("Testing that the execution takes an exact amount of seconds is not helpful...")
    @Test
    public void testExecute() {
        final Instant before1 = Instant.now();
        doExecuteSuccessfully(new SleepCommand());
        final Instant after1 = Instant.now();
        assertEquals(5, after1.getEpochSecond() - before1.getEpochSecond());


        final Instant before2 = Instant.now();
        doExecuteSuccessfully(new SleepCommand(), "1");
        final Instant after2 = Instant.now();
        assertEquals(1, after2.getEpochSecond() - before2.getEpochSecond());

        doExecuteUnsuccessfully(new SleepCommand(), NumberFormatException.class, "3.7");
        doExecuteUnsuccessfully(new SleepCommand(), NumberFormatException.class, "asdf");
    }
}
