package de.renew.plugin.jpms.impl;

import java.util.List;
import java.util.Objects;

import de.renew.plugin.jpms.ComponentLayer;


/**
 * A layer of one or more third-party libraries denoted by a global identifier.
 *
 * @param id the global identifier of this component.
 * @param control the controller that governs this component's module layer.
 * @param parents this component's parents.
 *
 * @author Kjell Ehlers
 * @since Renew 4.2
 */
record LibraryLayer(long id, ModuleLayer.Controller control,
    List<ComponentLayer> parents) implements ComponentLayer {
    public LibraryLayer {
        Objects.requireNonNull(control);

        // defensive copy and implicit null-check of parents
        parents = List.copyOf(parents);
    }

    @Override
    public String getName() {
        return "LibraryLayer " + id;
    }

    @Override
    public ModuleLayer.Controller getController() {
        return control;
    }

    @Override
    public List<ComponentLayer> parents() {
        return parents;
    }
}
