package de.renew.plugin.jpms;

import java.util.List;


/**
 * This exception is thrown by the Module manager if a module layer can not be removed
 */
public class ModuleLayerRemoveException extends ModuleConfigurationException {

    /**
     * Creates the exception for the case if the module layer that should be removed have children.
     * @param moduleLayerName The module layer that should be removed
     * @param childrenOfModuleLayer The children of the module layer
     */
    public ModuleLayerRemoveException(String moduleLayerName, List<String> childrenOfModuleLayer) {
        super(buildMessage(moduleLayerName, childrenOfModuleLayer));
    }

    /**
     * Creates the exception message for the case that the module layer which should be removed has children.
     * @param moduleLayerName The module layer that should be removed
     * @param childrenOfModuleLayer The children of the module layer
     * @return The exception message
     * @author Laif-Oke Clasen
     */
    private static String buildMessage(String moduleLayerName, List<String> childrenOfModuleLayer) {
        return "ModuleLayerRemoveException: " + moduleLayerName + " has children: "
            + String.join(" | ", childrenOfModuleLayer);
    }
}
