package de.renew.plugin.command;

import java.io.PrintStream;


/**
 * Command to wait for given (currently 5 seconds) time
 * @author Lawrence Cabac (cabac@inf...)
 *
 */
public class SleepCommand implements CLCommand {
    /**
     * Logger for logging purposes as specified by Apache Log4j
     */
    private static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(SleepCommand.class);

    /**
     * The name for this command.
     */
    public final static String CMD = "sleep";

    /**
     * Empty Constructor for sleep command
     */
    public SleepCommand() {
        // nothing to do
    }

    @Override
    public void execute(String[] args, PrintStream response) {
        int waitingTime = 5; // in seconds
        if (args.length > 0) {
            waitingTime = Integer.parseInt(args[0]);
        }
        try {
            response.println("SCRIPT: sleeping for " + waitingTime + " seconds ...");
            Thread.sleep(waitingTime * 1000);
            response.println("SCRIPT: ...done! Continuing with script execution.");
        } catch (InterruptedException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(
                    SleepCommand.class.getSimpleName() + ": interrupted. This should not happen!");
            }
        }
    }

    @Override
    public String getDescription() {
        return "This command waits for a given time until the next command is executed.";
    }

    @Override
    public String getArguments() {
        return "3";
    }
}