package de.renew.plugin;


/**
 * This class is a wrapper class for any exceptions thrown
 * while the framework is dealing with plugins.
 * There is a method that lets you extract the causing
 * exception if any (<code>getCause</code>).
 */
public class PluginException extends Exception {
    /**
     * Constructor to initialize PluginException without receipt of message
     */
    public PluginException() {
        super();
    }

    /**
     * Constructor to initialize PluginException with receipt of message
     * @param message to be handed over to PluginException
     */
    public PluginException(String message) {
        super(message);
    }

    /**
     * Creates a new <code>PluginException</code> wrapping the
     * given <code>Throwable</code>. The message of the causing
     * exception is copied to this instance.
     *
     * @param ex Exception that was caught for wrapping in PluginException
     */
    public PluginException(Throwable ex) {
        this(ex.getMessage(), ex);
    }

    /**
     * Creates a new <code>PluginException</code> wrapping the
     * given <code>Throwable</code>. The message of the causing
     * exception is handed over as separate variable to this instance.
     * @param message Message of caught exception, to be added to PluginException
     * @param ex Exception that was caught for wrapping in PluginException
     */
    public PluginException(String message, Throwable ex) {
        super(message, ex);
    }
}