package de.renew.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;


/**
 * This is a simple utility class containing static method that convert Collections (as from java.util.Collection)
 * into a rendered string.
 * The rendering of this string can be configured by a delimiter that will be
 * inserted between every element of the collection.
 */
public class CollectionLister {

    /**
     * Creates a String from the given collection.
     * The elements of the collections will be separated by a comma.
     * @param c A collection given to be turned into a string
     * @return A String of given collection members seperated by comma
     */
    public static String toString(Collection<?> c) {
        return toString(c, ", ");
    }

    /**
     * Creates a String from the given collection,
     * separating the elements of the collection with the given delimiter string.
     * @param c A collection given to be turned into a string
     * @param delim A String given as delimiter to separate the given collection
     * @return A String of given collection members seperated by a given String
     */
    public static String toString(Collection<?> c, String delim) {
        return toString(c.iterator(), delim);
    }

    /**
     * Creates a String from the given iterator.
     * The elements of the iterator will be separated by a comma.
     * @param c An Iterator given to be turned into a string
     * @return A String of given iterator members seperated by comma
     */
    public static String toString(Iterator<?> c) {
        return toString(c, ", ");
    }

    /**
     * Creates a String from the given iterator,
     * separating the elements of the iterator with the given delimiter string.
     * @param c An Iterator given to be turned into a string
     * @param delimiter A String given as delimiter to separate the given iterator
     * @return A String of given iterator members seperated by a given String
     */
    public static String toString(Iterator<?> c, String delimiter) {
        String result = "";
        while (c.hasNext()) {
            result += c.next();
            if (c.hasNext()) {
                result += delimiter;
            }
        }
        return result;
    }

    /**
     * Creates a String from the given Array,
     * separating elements by a comma.
     * @param array An array given to be turned into a string
     * @return A String of given array members seperated by a comma
     */
    public static String toString(Object[] array) {
        return toString(array, ",");
    }

    /**
     * Creates a String from the given Array,
     * with the elements separated by the given delimiter.
     * @param array An array given to be turned into a string
     * @param delimiter A String given as delimiter to separate the given array members
     * @return A String of given array members seperated by a given String
     */
    public static String toString(Object[] array, String delimiter) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; i++) {
            if (i != 0) {
                result.append(delimiter);
            }
            result.append(array[i]);
        }
        return result.toString();
    }

    /**
     * Creates an ArrayList from a given Iterator of Strings
     * @param it The Iterator to be turned into an ArrayList
     * @return An Arraylist created from a given Iterator of Strings
     */
    public static ArrayList<String> toArrayList(Iterator<String> it) {
        ArrayList<String> result = new ArrayList<String>();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }
}