<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# SamplePlugin

## User Guide

The plugin _LayoutWindow_ provides the layout (like align, spread ...) functions in
a separate gui window.


### Features

- A dedicated GUI for layout functions.

### Example Usage

1. Create a drawing of any kind in the Renew Editor.
2. Open the Layout Window via the menu: `Layout -> Layout Window`.
3. Use the buttons in the Layout Window to apply various layout functions to your drawing.

### Installation

Install _LayoutWindow_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Loader`: (mandated)
- `CH`: Adds a new menu item and uses the layout functions from the CH plugin.

### Configuration

During the initialization of LayoutWindow, the following properties are read from the `renew.properties` file in the Renew root directory.

| **NAME**                       | **TYPE** | **DESCRIPTION**                               | **DEFAULT** |
|:-------------------------------|:--------:|:----------------------------------------------|:------------|
| `de.renew.layoutwindow.enable` | boolean  | Specifies, if the menu entry should be added. | `true`      |

## Developer Guide

### Core Classes

- `LayoutWindowPlugin`: Extends the `DIPlugin` class to manage the startup and shutdown and dependency injection of the plugin.
- `LayoutWindow`: The main GUI window that provides layout functions.

### How to Extend

There are no extension points in this plugin, as it is a standalone GUI for layout functions.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

<!-- Contribution Info -->

<!-- License -->
