package de.renew.io;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

import de.renew.io.api.FileApi;
import de.renew.ioontology.ExtensionFileFilter;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.ArgumentMatchers.any;

class FileFilterCreatorTest {

    private MockedStatic<FileApi> _mockedFileApi;
    private ExtensionFileFilter _mockedExtensionFileFilter;

    @BeforeEach
    void setUp() {
        _mockedFileApi = Mockito.mockStatic(FileApi.class);
        _mockedExtensionFileFilter = Mockito.mock(ExtensionFileFilter.class);
        _mockedFileApi.when(() -> FileApi.createExtensionFileFilter(any(), any()))
            .thenReturn(_mockedExtensionFileFilter);
    }

    @AfterEach
    void tearDown() {
        _mockedFileApi.close();
        _mockedFileApi = null;
        _mockedExtensionFileFilter = null;
    }

    @Test
    void testCreatePNMLFileFilter() {
        // when
        ExtensionFileFilter actualExtensionFileFilter = FileFilterCreator.createPNMLFileFilter();

        // then
        assertThat(actualExtensionFileFilter).isSameAs(_mockedExtensionFileFilter);
        _mockedFileApi.verify(() -> FileApi.createExtensionFileFilter("pnml", "Renew PNML File"));
    }

    @Test
    void testCreatePSFileFilter() {
        // when
        ExtensionFileFilter actualExtensionFileFilter = FileFilterCreator.createPSFileFilter();

        // then
        assertThat(actualExtensionFileFilter).isSameAs(_mockedExtensionFileFilter);
        _mockedFileApi.verify(() -> FileApi.createExtensionFileFilter("ps", "Post Script File"));
    }

    @Test
    void testCreateRNWFileFilter() {
        // when
        ExtensionFileFilter actualExtensionFileFilter = FileFilterCreator.createRNWFileFilter();

        // then
        assertThat(actualExtensionFileFilter).isSameAs(_mockedExtensionFileFilter);
        _mockedFileApi
            .verify(() -> FileApi.createExtensionFileFilter("rnw", "Net Drawing (*.rnw)"));
    }

    @Test
    void testCreateRSTFileFilter() {
        // when
        ExtensionFileFilter actualExtensionFileFilter = FileFilterCreator.createRSTFileFilter();

        // then
        assertThat(actualExtensionFileFilter).isSameAs(_mockedExtensionFileFilter);
        _mockedFileApi
            .verify(() -> FileApi.createExtensionFileFilter("rst", "Renew Simulation State"));
    }

    @Test
    void testCreateSNSFileFilter() {
        // when
        ExtensionFileFilter actualExtensionFileFilter = FileFilterCreator.createSNSFileFilter();

        // then
        assertThat(actualExtensionFileFilter).isSameAs(_mockedExtensionFileFilter);
        _mockedFileApi
            .verify(() -> FileApi.createExtensionFileFilter("sns", "Renew Shadow Net System"));
    }

    @Test
    void testCreateWoflanFileFilter() {
        // when
        ExtensionFileFilter actualExtensionFileFilter = FileFilterCreator.createWoflanFileFilter();

        // then
        assertThat(actualExtensionFileFilter).isSameAs(_mockedExtensionFileFilter);
        _mockedFileApi.verify(() -> FileApi.createExtensionFileFilter("tpn", "Woflan"));
    }
}