package de.renew.io.exportFormats;

import java.io.File;
import javax.naming.OperationNotSupportedException;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormatMulti;
import de.renew.gui.CPNDrawing;

/**
 * Formats XML Files for Export.
 */
public class XMLExportFormat extends AbstractDrawingExportFormatMulti {

    /**
     * Constructor for an XMLExportFormat
     */
    public XMLExportFormat() {
        super("XML", "XML FileFilter");
        init();
    }

    /**
      * Initiation for XMLImportFormat
      */
    protected void init() {
        addExportFormat(new PNMLPTExportFormat());
        addExportFormat(new PNMLPTwtiExportFormat());
        addExportFormat(new PNMLRefNetExportFormat());
    }

    @Override
    public File export(Drawing drawing, File path) throws Exception {
        // TODO should this method exist in implementations of ExportFormatMultiAbstract?
        throw new OperationNotSupportedException();
    }


    @Override
    public File export(Drawing[] drawings, File path) throws Exception {
        // TODO should this method exist in implementations of ExportFormatMultiAbstract?
        throw new OperationNotSupportedException();
    }

    @Override
    public boolean canExportDrawing(Drawing drawing) {
        // TODO should this method exist in implementations of ExportFormatMultiAbstract?
        return drawing instanceof CPNDrawing;
    }
}