package de.renew.io;

import de.renew.io.api.FileApi;
import de.renew.ioontology.ExtensionFileFilter;

/**
 * Class to create the file filters of the GUI plugin.
 *
 * @author Clara von Bargen (3bargen)
 */
public final class FileFilterCreator {
    private FileFilterCreator() {}

    /**
     * Creates a file filter for PNML files.
     * @return the created file filter
     */
    public static ExtensionFileFilter createPNMLFileFilter() {
        return FileApi.createExtensionFileFilter("pnml", "Renew PNML File");
    }

    /**
     * Creates a file filter for PostScript files.
     * @return the created file filter
     */
    public static ExtensionFileFilter createPSFileFilter() {
        return FileApi.createExtensionFileFilter("ps", "Post Script File");
    }

    /**
     * Creates a file filter for Net Drawing (.rnw) files.
     * @return the created file filter
     */
    public static ExtensionFileFilter createRNWFileFilter() {
        return FileApi.createExtensionFileFilter("rnw", "Net Drawing (*.rnw)");
    }

    /**
     * Creates a file filter for Renew Simulation State (.rst) files.
     * @return the created file filter
     */
    public static ExtensionFileFilter createRSTFileFilter() {
        return FileApi.createExtensionFileFilter("rst", "Renew Simulation State");
    }

    /**
     * Creates a file filter for Renew Shadow Net System (.sns) files.
     * @return the created file filter
     */
    public static ExtensionFileFilter createSNSFileFilter() {
        return FileApi.createExtensionFileFilter("sns", "Renew Shadow Net System");
    }

    /**
     * Creates a file filter for Woflan (.tpn) files.
     * @return the created file filter
     */
    public static ExtensionFileFilter createWoflanFileFilter() {
        return FileApi.createExtensionFileFilter("tpn", "Woflan");
    }
}
