package de.renew.gui.pnml.parser;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import de.renew.gui.pnml.converter.NetConverter;


/**
 * parse attributes
 */
public class AttributeParser extends ElementParser {
    private String _text;

    public AttributeParser(Element attribute, NetConverter converter) {
        super(attribute, converter);
    }

    @Override
    protected void doParse() {
        NodeList texts = getElement().getElementsByTagName("text");
        if (texts.getLength() == 0) {
            texts = getElement().getElementsByTagName("value");
        }
        for (int pos = 0; pos < texts.getLength(); pos++) {
            Element textEle = (Element) texts.item(pos);
            Text text = (Text) textEle.getFirstChild();
            _text = text.getData();
        }
    }

    public String attributeName() {
        NetConverter con = getNetConverter();

        return con.convertAttributeNameToRenewName(getElement());
    }

    public String attributeValue() {
        return _text;
    }
}