package de.renew.gui.pnml.converter;

import org.w3c.dom.Element;

import de.renew.draw.storables.ontology.Figure;
import de.renew.io.exportFormats.PNMLExportFormat;


/**
 * Used to convert between the contents of a {@link de.renew.gui.CPNDrawing}
 * (in the form of {@link Figure} objects)
 * and the contents of an {@link Element} representing the same net
 * in a PNML file.
 * <p>
 * See also {@link Converter}.
 */
public class PTNetConverter extends NetConverterAbstract {

    /**
     * Constructor for PTNetConverter
     *
     * @param converter which is being used for conversion
     * @param toolInsc  weither the tool inscription should be converted or not
     */
    public PTNetConverter(Converter converter, boolean toolInsc) {
        super(converter, toolInsc);
    }

    /**
     * @param netType which is used for checking
     * @return weither the netType is of type ptNetType
     */
    public static boolean isNetParser(String netType) {
        return PNMLExportFormat.ptNetType.equals(netType)
            || "http://www.informatik.hu-berlin.de/top/pntd/ptNetb".equals(netType)
            || "http://ifnml.process-security.de/grammar/v1.0/ptnet".equals(netType);
    }

    @Override
    public boolean createPageTag() {
        return true;
    }
}