/*
 * Created on 28.01.2004
 *
 */
package de.renew.gui.menu;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.util.CommandMenu;
import de.renew.draw.ui.api.CommandApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.SelectionMode;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.InscribableFigure;
import de.renew.gui.NodeFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;


/**
 * This class is used by the Gui plugin to add items to the Edit menu.
 *
 * @author J&ouml;rn Schumacher
 */
public class EditMenuExtender {
    public Collection<JMenuItem> createMenus() {
        Collection<JMenuItem> result = new ArrayList<>();

        JMenu selectMenu = createSelectMenu(SelectionMode.SELECT);
        result.add(selectMenu);
        JMenu addSelectMenu = createSelectMenu(SelectionMode.ADD);
        result.add(addSelectMenu);
        JMenu removeSelectMenu = createSelectMenu(SelectionMode.REMOVE);
        result.add(removeSelectMenu);
        JMenu restrictSelectMenu = createSelectMenu(SelectionMode.RESTRICT);
        result.add(restrictSelectMenu);

        return result;
    }

    protected JMenu createSelectMenu(SelectionMode selectMode) {
        String selectMenuTitle = switch (selectMode) {
            case SELECT -> "Select";
            case ADD -> "Add To Selection";
            case REMOVE -> "Remove From Selection";
            case RESTRICT -> "Restrict Selection";
        };

        CommandMenu selectMenu = DrawApplication.createCommandMenu(selectMenuTitle);

        CommandMenu nodeMenu = DrawApplication.createCommandMenu("Nodes");

        nodeMenu.add(CommandApi.createSelectCommand("All", NodeFigure.class, selectMode));
        nodeMenu
            .add(CommandApi.createSelectCommand("Transitions", TransitionFigure.class, selectMode));
        nodeMenu.add(CommandApi.createSelectCommand("Places", PlaceFigure.class, selectMode));
        selectMenu.add(nodeMenu);

        selectMenu.add(CommandApi.createSelectCommand("Arcs", ArcConnection.class, selectMode));
        selectMenu.add(
            CommandApi.createSelectCommand("Nodes and Arcs", InscribableFigure.class, selectMode));

        CommandMenu textChildMenu = DrawApplication.createCommandMenu("Text Children");

        textChildMenu.add(
            CommandApi.createSelectCommand(
                "All", CPNTextFigure.class, InscribableFigure.class, selectMode));
        textChildMenu.add(
            CommandApi.createSelectCommand(
                "of Transitions", CPNTextFigure.class, TransitionFigure.class, selectMode));
        textChildMenu.add(
            CommandApi.createSelectCommand(
                "of Places", CPNTextFigure.class, PlaceFigure.class, selectMode));
        textChildMenu.add(
            CommandApi.createSelectCommand(
                "of Arcs", CPNTextFigure.class, ArcConnection.class, selectMode));

        selectMenu.add(textChildMenu);

        CommandMenu inscrMenu = DrawApplication.createCommandMenu("Inscriptions");

        inscrMenu.add(
            createSelectCommand(
                "All", InscribableFigure.class, CPNTextFigure.INSCRIPTION, selectMode));
        inscrMenu.add(
            createSelectCommand(
                "of Transitions", TransitionFigure.class, CPNTextFigure.INSCRIPTION, selectMode));
        inscrMenu.add(
            createSelectCommand(
                "of Places", PlaceFigure.class, CPNTextFigure.INSCRIPTION, selectMode));
        inscrMenu.add(
            createSelectCommand(
                "of Arcs", ArcConnection.class, CPNTextFigure.INSCRIPTION, selectMode));
        selectMenu.add(inscrMenu);

        CommandMenu nameMenu = DrawApplication.createCommandMenu("Names");

        nameMenu.add(
            createSelectCommand("All", InscribableFigure.class, CPNTextFigure.NAME, selectMode));
        nameMenu.add(
            createSelectCommand(
                "of Transitions", TransitionFigure.class, CPNTextFigure.NAME, selectMode));
        nameMenu.add(
            createSelectCommand("of Places", PlaceFigure.class, CPNTextFigure.NAME, selectMode));
        selectMenu.add(nameMenu);

        return selectMenu;
    }

    protected static AbstractCommand createSelectCommand(
        String title, final Class<?> parentClass, final int type, SelectionMode selectMode)
    {
        return CommandApi.createSelectCommand(
            title,
            fig -> fig instanceof CPNTextFigure
                && parentClass.isInstance(((ChildFigure) fig).parent())
                && ((CPNTextFigure) fig).getType() == type,
            selectMode);
    }
}