package de.renew.gui;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import de.renew.draw.storables.ontology.Drawing;


// Present an abstract way of generating and parsing XML
// files. This interface allows us to compile the main
// part of Renew without referencing any XML parser
// libraries. Furthermore, we can easily swap XML file
// formats.
public interface XMLFormat {
    boolean canExport();

    boolean canImport();

    // Throw a general exception, so that no reference
    // to e.g. SAXException is required.
    List<Drawing> parse(InputStream stream) throws Exception;

    void write(OutputStream stream, CPNDrawing drawing) throws Exception;

    void write(OutputStream stream, CPNDrawing[] drawings) throws Exception;
}