package de.renew.gui;

import java.io.Serializable;
import java.util.Hashtable;

import CH.ifa.draw.framework.FigureWithID;
import de.renew.remote.ObjectAccessor;


/**
 * A figure that represents elements that may be simulated and has a
 * direct representation in an instance drawing.
 */
public interface SimulableFigure extends FigureWithID {
    /**
     * Creates an instance figure for this figure.
     * @param drawing The instance drawing to create the figure for.
     * @param netElements The net elements.
     * @return The new instance figure.
     */
    InstanceFigure createInstanceFigure(
        InstanceDrawing drawing, Hashtable<Serializable, ObjectAccessor> netElements);

    /**
     * This method returns the semantic figure for this figure. This is
     * usually the figure itself but may be a different figure if this figure
     * is a graphical link to another figure (e.g. {@link VirtualPlaceFigure}).
     * <p>
     * The default implementation returns the figure itself
     *
     * @return the semantic figure that this figure is representation of
     */
    default FigureWithID getSemanticFigure() {
        return this;
    }
}
