package de.renew.gui;

import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.AbstractFigure;
import de.renew.draw.ui.api.EditorApi;


/**
 * Sets the currently selected figure as simulation icon
 * for the active drawing.
 * <p>
 * SetIconFigureCommand.java
 * Created: Fri Feb 23  2001
 * (Code moved from CPNApplication)
 *
 * @author Frank Wienberg, Michael Duvigneau
 */
public class SetIconFigureCommand extends UndoableCommand {

    public SetIconFigureCommand(String name) {
        super(name);
    }

    /**
     * @return <code>true</code>, if exactly one figure is selected.
     **/
    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return (EditorApi.getCurrentDrawing() instanceof CPNDrawing)
            && (getEditor().view().selectionCount() == 1);
    }

    @Override
    public boolean executeUndoable() {
        if (isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            ((CPNDrawing) EditorApi.getCurrentDrawing()).setIconFigure(
                (AbstractFigure) getEditor().view().selectionElements().nextFigure());
            return true;
        }
        return false;
    }
}