package de.renew.gui;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.util.Command;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.api.ErrorApi;


public class LayoutCheckCommand extends Command {
    private static final org.apache.log4j.Logger logger =
        org.apache.log4j.Logger.getLogger(LayoutCheckCommand.class);
    private static final double OVERLAPWARNINGTHRESHOLD = 0.5;

    public LayoutCheckCommand(String name) {
        super(name);
    }


    @Override
    public synchronized void execute() {
        try {
            CPNApplication application = (CPNApplication) DrawPlugin.getGui();
            Enumeration<Drawing> drawings = EditorApi.getCurrentDrawings();
            while (drawings.hasMoreElements()) {
                Drawing drawing = drawings.nextElement();
                checkSingleDrawing(drawing);
            }
        } catch (ClassCastException e) {
            logger.error(e.getMessage(), e);
        }
    }

    /**
     *  Computes the relative overlap factor of two rectangles
     *
     * @author Michael Koehler, Heiko Roelke
     *
     */
    private double overlap(Rectangle r1, Rectangle r2) {
        Rectangle intersection = r1.intersection(r2);
        if (intersection.isEmpty()) {
            return 0.0;
        } else {
            double intersectionArea = intersection.height * intersection.width;
            double r1Area = r1.height * r1.width;
            double r2Area = r2.height * r2.width;
            return Math.max(intersectionArea / r1Area, intersectionArea / r2Area);
        }
    }

    /**
     *  Checks whether a @see CH.ifa.draw.figures.TextFigure is hidden
     *  by an overlapping TextFigure
     *
     * @author Michael Koehler, Heiko Roelke
     *
     *
     */
    private void checkSingleDrawing(Drawing drawing) {
        List<TextFigure> allTextFigures = new Vector<>();
        FigureEnumeration figures = drawing.figures();
        boolean overlapFound = false;

        while (figures.hasMoreElements() && !overlapFound) {
            Figure figure = figures.nextFigure();

            if (figure instanceof TextFigure textFigure) {
                Rectangle figureRectangle = figure.displayBox();

                for (TextFigure compareTextFigure : allTextFigures) {
                    Rectangle compareRectangle = compareTextFigure.displayBox();

                    overlapFound =
                        (overlap(figureRectangle, compareRectangle) > OVERLAPWARNINGTHRESHOLD);
                    if (overlapFound) {
                        GuiPlugin.getCurrent()
                            .processFigureException(
                                ErrorApi.createErrorState(
                                    "Warning", "Overlapping figures detected", drawing, figure),
                                true);
                        break;
                    }
                }
                if (!overlapFound) {
                    allTextFigures.add(textFigure);
                }
            }
        }
        if (!overlapFound) {
            DrawPlugin.getGui().showStatus("Layout check successful");
        }
    }
}