package de.renew.gui;

import CH.ifa.draw.framework.ParentFigure;
import de.renew.draw.ui.ontology.DrawingView;

/** Tag interface for figures which have a semantical meaning
 * (ShadowHolders) and can include inscriptions.
 */
public interface InscribableFigure extends ShadowHolder, ParentFigure {

    /**
     * This method is called whenever an InscribableFigure is right-clicked. The default behavior is creating/selecting
     * an inscription; for this purpose, this method should return true. Whenever that behavior is overridden, this
     * method should return false. Any SelectionTool implementation should then call #inspect(view, false).
     * @param view the current view in which the click occurred
     * @return true if this figure should be inscribed, false if #inspect should be called instead
     */
    default boolean shouldInscribeOnAltInspect(DrawingView view) {
        return true;
    }
}