/*
 * @(#)HollowDoubleArcConnection.java 5.1
 *
 */
package de.renew.gui;

import CH.ifa.draw.util.ColorMap;
import de.renew.draw.storables.ontology.Figure;
import de.renew.simulatorontology.shadow.ShadowArc;


public class HollowDoubleArcConnection extends ArcConnection {
    public static final HollowDoubleArcConnection HollowArc = new HollowDoubleArcConnection();

    public HollowDoubleArcConnection() {
        setFillColor(ColorMap.BACKGROUND);

        fArrowTipClass = DoubleArrowTip.class;
        setStartDecoration(null);
        setEndDecoration();
    }

    @Override
    protected void setStartDecoration() {
        setStartDecoration(new DoubleArrowTip(0.40, 8, 8, false));
    }

    @Override
    protected void setEndDecoration() {
        setEndDecoration(new DoubleArrowTip(0.40, 8, 8, false));
    }

    @Override
    public int getArcType() {
        return ShadowArc.DOUBLE_HOLLOW;
    }

    @Override
    public boolean canConnect(Figure start, Figure end) {
        return (start instanceof PlaceFigure && end instanceof TransitionFigure);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("ArrowMode")) {
            // Ignore. Not yet implemented.
        } else {
            super.setAttribute(name, value);
        }
    }
}