package de.renew.gui;

import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;

import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.api.ErrorApi;
import de.renew.draw.ui.ontology.ErrorState;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import de.renew.simulatorontology.shadow.SyntaxException;


// Some time ago, this class extended java.lang.Exception, but why?
public class FigureExceptionFactory {
    private static final Logger logger = Logger.getLogger(FigureExceptionFactory.class);

    // the following should all be final, but compiler bug...
    public static ErrorState createFigureException(
        SyntaxException e, Drawing errorDrawing, TextFigure textErrorFigure)
    {
        int line = e.getLine();
        int column = e.getColumn();
        String message = e.getMessage();
        Object o = e.getProblemSpecificInformation();
        logger.debug("Syntax Error: ", e);

        return ErrorApi.createErrorState(message, line, column, errorDrawing, textErrorFigure, o);

    }

    public static ErrorState createFigureException(SyntaxException e) {
        int line = e.getLine();
        int column = e.getColumn();
        String message = e.getMessage();
        Object o = e.getProblemSpecificInformation();
        TextFigure textErrorFigure = null;
        Drawing errorDrawing;
        final Vector<Figure> errorFigures = new Vector<>();

        if (!e.getErrorObjects().isEmpty()) {
            // Determine the offending drawing.
            errorDrawing = CPNDrawing.findDrawing(e.getErrorObjects().elementAt(0));
            if (errorDrawing != null) {
                boolean errorFound = false;
                Enumeration<Object> errorObjects = e.getErrorObjects().elements();
                while (errorObjects.hasMoreElements()) {
                    Object errorObject = errorObjects.nextElement();
                    Figure errorFigure = null;
                    if (errorObject instanceof ShadowNetElement) {
                        errorFigure = (Figure) ((ShadowNetElement) errorObject).getContext();
                    }
                    if (errorFigure != null) {
                        if (errorFound) {
                            textErrorFigure = null;
                            // only invoke text editor for single error objects!
                        } else {
                            errorFound = true;
                            if (e.getLine() > 0 && e.getColumn() > 0
                                && errorFigure instanceof TextFigure textFigure
                                && textFigure.acceptsTyping()) {
                                textErrorFigure = textFigure;
                            }
                        }
                        errorFigures.addElement(errorFigure);
                    }
                }
            }
        } else {
            errorDrawing = null;
        }
        logger.debug("Syntax Error: ", e);


        return ErrorApi.createErrorState(
            message, line, column, errorDrawing, textErrorFigure, errorFigures, o);
    }
}