package de.renew.gui;

import java.util.EventObject;

import de.renew.draw.storables.ontology.Figure;

/**
 * CPNFigure event passed to CPNFigureListeners.
 */
public class CPNFigureEvent extends EventObject {
    private final Figure _figure;

    /**
     * Constructs an event for the given source Figure.
     * @param source the object on which the Event initially occurred.
     * @param figure the figure of the source
     */
    public CPNFigureEvent(Object source, Figure figure) {
        super(source);
        _figure = figure;
    }

    /**
     * Gets the figure of the source.
     * @return returns the figure
     */
    public Figure getFigure() {
        return _figure;
    }

    @Override
    public String toString() {
        return "CPNFigureEvent{source=" + source + ", _figure=" + _figure + '}';
    }
}
