package de.renew.gui;

/**
 * Describes the listener interface that must be implemented
 * by objects which wants to be informed when a breakpoint
 * is hit in a simulation.
 *
 * @author Sven Offermann
 *
 */
public interface BreakpointHitListener {
    /**
     * Called by the {@link BreakpointManager} when a breakpoint is hit.
     *
     * <p>Note that this method runs in a simulation thread and thus can impact simulation speed.
     * 
     * @param event contains information about the breakpoint that was hit
     */
    void hitBreakpoint(BreakpointHitEvent event);
}
